/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.WindowScreen;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.pathing.PathManagers;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StorageBlockListSetting;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.MeteorToast;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2609;
import net.minecraft.class_2611;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_2636;
import net.minecraft.class_368;
import net.minecraft.class_3719;
import net.minecraft.class_437;

public class AdvancedStashFinder
extends Module {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final SettingGroup sgGeneral;
    private final SettingGroup sgWebhook;
    private final Setting<List<class_2591<?>>> storageBlocks;
    private final Setting<Integer> minimumStorageCount;
    private final Setting<Integer> minimumDistance;
    private final Setting<Boolean> criticalSpawner;
    private final Setting<Boolean> sendNotifications;
    private final Setting<Mode> notificationMode;
    private final Setting<Boolean> enableWebhook;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;
    public List<Chunk> chunks;
    private final HttpClient httpClient;

    public AdvancedStashFinder() {
        super(CatalystAddon.CATEGORY, "StashFinder", "stash finder with webhook support.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgWebhook = this.settings.createGroup("Webhook");
        this.storageBlocks = this.sgGeneral.add((Setting)((StorageBlockListSetting.Builder)((StorageBlockListSetting.Builder)new StorageBlockListSetting.Builder().name("storage-blocks")).description("Select the storage blocks to search for.")).defaultValue(StorageBlockListSetting.STORAGE_BLOCKS).build());
        this.minimumStorageCount = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("minimum-storage-count")).description("The minimum amount of storage blocks in a chunk to record the chunk.")).defaultValue((Object)4)).min(1).sliderMin(1).sliderMax(100).build());
        this.minimumDistance = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("minimum-distance")).description("The minimum distance you must be from spawn to record a certain chunk.")).defaultValue((Object)0)).min(0).sliderMax(10000).build());
        this.criticalSpawner = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("critical-spawner")).description("Mark chunk as stash even if only a single spawner is found.")).defaultValue((Object)true)).build());
        this.sendNotifications = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("notifications")).description("Sends Minecraft notifications when new stashes are found.")).defaultValue((Object)true)).build());
        this.notificationMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("notification-mode")).description("The mode to use for notifications.")).defaultValue((Object)Mode.Both)).visible(() -> this.sendNotifications.get())).build());
        this.enableWebhook = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("webhook")).description("Send webhook notifications when stashes are found")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL")).defaultValue((Object)"")).visible(() -> this.enableWebhook.get())).build());
        this.selfPing = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("self-ping")).description("Ping yourself in the webhook message")).defaultValue((Object)false)).visible(() -> this.enableWebhook.get())).build());
        this.discordId = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("discord-id")).description("Your Discord user ID for pinging")).defaultValue((Object)"")).visible(() -> (Boolean)this.enableWebhook.get() != false && (Boolean)this.selfPing.get() != false)).build());
        this.chunks = new ArrayList<Chunk>();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public void onActivate() {
        this.load();
    }

    @EventHandler
    private void onChunkData(ChunkDataEvent event) {
        double chunkZAbs;
        double chunkXAbs = Math.abs(event.chunk().method_12004().field_9181 * 16);
        if (Math.sqrt(chunkXAbs * chunkXAbs + (chunkZAbs = (double)Math.abs(event.chunk().method_12004().field_9180 * 16)) * chunkZAbs) < (double)((Integer)this.minimumDistance.get()).intValue()) {
            return;
        }
        Chunk chunk = new Chunk(event.chunk().method_12004());
        for (class_2586 blockEntity : event.chunk().method_12214().values()) {
            class_2591 type = blockEntity.method_11017();
            if (blockEntity instanceof class_2636) {
                ++chunk.spawners;
                continue;
            }
            if (!((List)this.storageBlocks.get()).contains(type)) continue;
            if (blockEntity instanceof class_2595) {
                ++chunk.chests;
                continue;
            }
            if (blockEntity instanceof class_3719) {
                ++chunk.barrels;
                continue;
            }
            if (blockEntity instanceof class_2627) {
                ++chunk.shulkers;
                continue;
            }
            if (blockEntity instanceof class_2611) {
                ++chunk.enderChests;
                continue;
            }
            if (blockEntity instanceof class_2609) {
                ++chunk.furnaces;
                continue;
            }
            if (blockEntity instanceof class_2601) {
                ++chunk.dispensersDroppers;
                continue;
            }
            if (!(blockEntity instanceof class_2614)) continue;
            ++chunk.hoppers;
        }
        boolean isStash = false;
        boolean isCriticalSpawner = false;
        Object detectionReason = "";
        if (((Boolean)this.criticalSpawner.get()).booleanValue() && chunk.spawners > 0) {
            isStash = true;
            isCriticalSpawner = true;
            detectionReason = "Spawner(s) detected (Critical mode)";
        } else if (chunk.getTotal() >= (Integer)this.minimumStorageCount.get()) {
            isStash = true;
            detectionReason = "Storage threshold reached (" + chunk.getTotal() + " blocks)";
        }
        if (isStash) {
            Chunk prevChunk = null;
            int i = this.chunks.indexOf(chunk);
            if (i < 0) {
                this.chunks.add(chunk);
            } else {
                prevChunk = this.chunks.set(i, chunk);
            }
            this.saveJson();
            this.saveCsv();
            if (!(!((Boolean)this.sendNotifications.get()).booleanValue() || chunk.equals(prevChunk) && chunk.countsEqual(prevChunk))) {
                String stashType = isCriticalSpawner ? "spawner base" : "stash";
                switch (((Mode)((Object)this.notificationMode.get())).ordinal()) {
                    case 0: {
                        this.info("Found %s at (highlight)%s(default), (highlight)%s(default). %s", new Object[]{stashType, chunk.x, chunk.z, detectionReason});
                        break;
                    }
                    case 1: {
                        MeteorToast toast = new MeteorToast(class_1802.field_8106, this.title, "Found " + stashType.substring(0, 1).toUpperCase() + stashType.substring(1) + "!");
                        this.mc.method_1566().method_1999((class_368)toast);
                        break;
                    }
                    case 2: {
                        this.info("Found %s at (highlight)%s(default), (highlight)%s(default). %s", new Object[]{stashType, chunk.x, chunk.z, detectionReason});
                        MeteorToast toast = new MeteorToast(class_1802.field_8106, this.title, "Found " + stashType.substring(0, 1).toUpperCase() + stashType.substring(1) + "!");
                        this.mc.method_1566().method_1999((class_368)toast);
                    }
                }
            }
            if (!(!((Boolean)this.enableWebhook.get()).booleanValue() || chunk.equals(prevChunk) && chunk.countsEqual(prevChunk))) {
                this.sendWebhookNotification(chunk, isCriticalSpawner, (String)detectionReason);
            }
        }
    }

    private void sendWebhookNotification(Chunk chunk, boolean isCriticalSpawner, String detectionReason) {
        String url = ((String)this.webhookUrl.get()).trim();
        if (url.isEmpty()) {
            this.warning("Webhook URL not configured!", new Object[0]);
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String serverInfo = this.mc.method_1558() != null ? this.mc.method_1558().field_3761 : "Unknown Server";
                String messageContent = "";
                if (((Boolean)this.selfPing.get()).booleanValue() && !((String)this.discordId.get()).trim().isEmpty()) {
                    messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
                }
                String stashType = isCriticalSpawner ? "Spawner Base" : "Stash";
                String description = String.format("%s found at coordinates %d, %d!", stashType, chunk.x, chunk.z);
                StringBuilder itemsFound = new StringBuilder();
                int totalItems = 0;
                if (chunk.spawners > 0) {
                    itemsFound.append("Spawners: ").append(chunk.spawners).append("\\n");
                    totalItems += chunk.spawners;
                }
                if (chunk.chests > 0) {
                    itemsFound.append("Chests: ").append(chunk.chests).append("\\n");
                    totalItems += chunk.chests;
                }
                if (chunk.barrels > 0) {
                    itemsFound.append("Barrels: ").append(chunk.barrels).append("\\n");
                    totalItems += chunk.barrels;
                }
                if (chunk.shulkers > 0) {
                    itemsFound.append("Shulker Boxes: ").append(chunk.shulkers).append("\\n");
                    totalItems += chunk.shulkers;
                }
                if (chunk.enderChests > 0) {
                    itemsFound.append("Ender Chests: ").append(chunk.enderChests).append("\\n");
                    totalItems += chunk.enderChests;
                }
                if (chunk.furnaces > 0) {
                    itemsFound.append("Furnaces: ").append(chunk.furnaces).append("\\n");
                    totalItems += chunk.furnaces;
                }
                if (chunk.dispensersDroppers > 0) {
                    itemsFound.append("Dispensers/Droppers: ").append(chunk.dispensersDroppers).append("\\n");
                    totalItems += chunk.dispensersDroppers;
                }
                if (chunk.hoppers > 0) {
                    itemsFound.append("Hoppers: ").append(chunk.hoppers).append("\\n");
                    totalItems += chunk.hoppers;
                }
                String jsonPayload = String.format("{\"content\":\"%s\",\"username\":\"Advanced Stashfinder\",\"avatar_url\":\"https://i.imgur.com/OL2y1cr.png\",\"embeds\":[{\"title\":\"\ud83d\udce6 Advanced Stashfinder Alert\",\"description\":\"%s\",\"color\":%d,\"fields\":[{\"name\":\"Detection Reason\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Total Items Found\",\"value\":\"%d\",\"inline\":false},{\"name\":\"Items Breakdown\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Coordinates\",\"value\":\"%d, %d\",\"inline\":true},{\"name\":\"Server\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Time\",\"value\":\"<t:%d:R>\",\"inline\":true}],\"footer\":{\"text\":\"Advanced Stashfinder\"}}]}", messageContent.replace("\"", "\\\""), description.replace("\"", "\\\""), isCriticalSpawner ? 0xFF0000 : 3066993, detectionReason.replace("\"", "\\\""), totalItems, itemsFound.toString().replace("\"", "\\\""), chunk.x, chunk.z, serverInfo.replace("\"", "\\\""), System.currentTimeMillis() / 1000L);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 204) {
                    this.info("Webhook notification sent successfully", new Object[0]);
                } else {
                    this.error("Webhook failed with status: " + response.statusCode(), new Object[0]);
                }
            }
            catch (IOException | InterruptedException e) {
                this.error("Failed to send webhook: " + e.getMessage(), new Object[0]);
            }
        });
    }

    public WWidget getWidget(GuiTheme theme) {
        this.chunks.sort(Comparator.comparingInt(value -> -value.getTotal()));
        WVerticalList list = theme.verticalList();
        WButton clear = (WButton)list.add((WWidget)theme.button("Clear")).widget();
        WTable table = new WTable();
        if (!this.chunks.isEmpty()) {
            list.add((WWidget)table);
        }
        clear.action = () -> {
            this.chunks.clear();
            table.clear();
        };
        this.fillTable(theme, table);
        return list;
    }

    private void fillTable(GuiTheme theme, WTable table) {
        for (Chunk chunk : this.chunks) {
            table.add((WWidget)theme.label("Pos: " + chunk.x + ", " + chunk.z));
            table.add((WWidget)theme.label("Total: " + chunk.getTotal()));
            WButton open = (WButton)table.add((WWidget)theme.button("Open")).widget();
            open.action = () -> this.mc.method_1507((class_437)new ChunkScreen(theme, chunk));
            WButton gotoBtn = (WButton)table.add((WWidget)theme.button("Goto")).widget();
            gotoBtn.action = () -> PathManagers.get().moveTo(new class_2338(chunk.x, 0, chunk.z), true);
            WMinus delete = (WMinus)table.add((WWidget)theme.minus()).widget();
            delete.action = () -> {
                if (this.chunks.remove(chunk)) {
                    table.clear();
                    this.fillTable(theme, table);
                    this.saveJson();
                    this.saveCsv();
                }
            };
            table.row();
        }
    }

    private void load() {
        block10: {
            Reader reader;
            File file;
            boolean loaded;
            block9: {
                loaded = false;
                file = this.getJsonFile();
                if (file.exists()) {
                    try {
                        reader = new FileReader(file);
                        this.chunks = (List)GSON.fromJson(reader, new TypeToken<List<Chunk>>(){}.getType());
                        ((InputStreamReader)reader).close();
                        for (Chunk chunk : this.chunks) {
                            chunk.calculatePos();
                        }
                        loaded = true;
                    }
                    catch (Exception ignored) {
                        if (this.chunks != null) break block9;
                        this.chunks = new ArrayList<Chunk>();
                    }
                }
            }
            file = this.getCsvFile();
            if (!loaded && file.exists()) {
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(file));
                    ((BufferedReader)reader).readLine();
                    while ((line = ((BufferedReader)reader).readLine()) != null) {
                        String[] values = line.split(",");
                        Chunk chunk = new Chunk(new class_1923(Integer.parseInt(values[0]), Integer.parseInt(values[1])));
                        chunk.chests = Integer.parseInt(values[2]);
                        chunk.barrels = Integer.parseInt(values[3]);
                        chunk.shulkers = Integer.parseInt(values[4]);
                        chunk.enderChests = Integer.parseInt(values[5]);
                        chunk.furnaces = Integer.parseInt(values[6]);
                        chunk.dispensersDroppers = Integer.parseInt(values[7]);
                        chunk.hoppers = Integer.parseInt(values[8]);
                        if (values.length > 9) {
                            chunk.spawners = Integer.parseInt(values[9]);
                        }
                        this.chunks.add(chunk);
                    }
                    ((BufferedReader)reader).close();
                }
                catch (Exception ignored) {
                    if (this.chunks != null) break block10;
                    this.chunks = new ArrayList<Chunk>();
                }
            }
        }
    }

    private void saveCsv() {
        try {
            File file = this.getCsvFile();
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            writer.write("X,Z,Chests,Barrels,Shulkers,EnderChests,Furnaces,DispensersDroppers,Hoppers,Spawners\n");
            for (Chunk chunk : this.chunks) {
                chunk.write(writer);
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveJson() {
        try {
            File file = this.getJsonFile();
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            GSON.toJson(this.chunks, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getJsonFile() {
        return new File(new File(new File(MeteorClient.FOLDER, "stashes"), Utils.getFileWorldName()), "advanced-stashes.json");
    }

    private File getCsvFile() {
        return new File(new File(new File(MeteorClient.FOLDER, "stashes"), Utils.getFileWorldName()), "advanced-stashes.csv");
    }

    public String getInfoString() {
        return String.valueOf(this.chunks.size());
    }

    public static enum Mode {
        Chat,
        Toast,
        Both;

    }

    public static class Chunk {
        private static final StringBuilder sb = new StringBuilder();
        public class_1923 chunkPos;
        public transient int x;
        public transient int z;
        public int chests;
        public int barrels;
        public int shulkers;
        public int enderChests;
        public int furnaces;
        public int dispensersDroppers;
        public int hoppers;
        public int spawners;

        public Chunk(class_1923 chunkPos) {
            this.chunkPos = chunkPos;
            this.calculatePos();
        }

        public void calculatePos() {
            this.x = this.chunkPos.field_9181 * 16 + 8;
            this.z = this.chunkPos.field_9180 * 16 + 8;
        }

        public int getTotal() {
            return this.chests + this.barrels + this.shulkers + this.enderChests + this.furnaces + this.dispensersDroppers + this.hoppers + this.spawners;
        }

        public void write(Writer writer) throws IOException {
            sb.setLength(0);
            sb.append(this.x).append(',').append(this.z).append(',');
            sb.append(this.chests).append(',').append(this.barrels).append(',').append(this.shulkers).append(',').append(this.enderChests).append(',').append(this.furnaces).append(',').append(this.dispensersDroppers).append(',').append(this.hoppers).append(',').append(this.spawners).append('\n');
            writer.write(sb.toString());
        }

        public boolean countsEqual(Chunk c) {
            if (c == null) {
                return false;
            }
            return this.chests != c.chests || this.barrels != c.barrels || this.shulkers != c.shulkers || this.enderChests != c.enderChests || this.furnaces != c.furnaces || this.dispensersDroppers != c.dispensersDroppers || this.hoppers != c.hoppers || this.spawners != c.spawners;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Chunk chunk = (Chunk)o;
            return Objects.equals(this.chunkPos, chunk.chunkPos);
        }

        public int hashCode() {
            return Objects.hash(this.chunkPos);
        }
    }

    private static class ChunkScreen
    extends WindowScreen {
        private final Chunk chunk;

        public ChunkScreen(GuiTheme theme, Chunk chunk) {
            super(theme, "Chunk at " + chunk.x + ", " + chunk.z);
            this.chunk = chunk;
        }

        public void initWidgets() {
            WTable t = (WTable)this.add((WWidget)this.theme.table()).expandX().widget();
            t.add((WWidget)this.theme.label("Total:"));
            t.add((WWidget)this.theme.label("" + this.chunk.getTotal()));
            t.row();
            t.add((WWidget)this.theme.horizontalSeparator()).expandX();
            t.row();
            t.add((WWidget)this.theme.label("Chests:"));
            t.add((WWidget)this.theme.label("" + this.chunk.chests));
            t.row();
            t.add((WWidget)this.theme.label("Barrels:"));
            t.add((WWidget)this.theme.label("" + this.chunk.barrels));
            t.row();
            t.add((WWidget)this.theme.label("Shulkers:"));
            t.add((WWidget)this.theme.label("" + this.chunk.shulkers));
            t.row();
            t.add((WWidget)this.theme.label("Ender Chests:"));
            t.add((WWidget)this.theme.label("" + this.chunk.enderChests));
            t.row();
            t.add((WWidget)this.theme.label("Spawners:"));
            t.add((WWidget)this.theme.label("" + this.chunk.spawners));
            t.row();
            t.add((WWidget)this.theme.label("Furnaces:"));
            t.add((WWidget)this.theme.label("" + this.chunk.furnaces));
            t.row();
            t.add((WWidget)this.theme.label("Dispensers and droppers:"));
            t.add((WWidget)this.theme.label("" + this.chunk.dispensersDroppers));
            t.row();
            t.add((WWidget)this.theme.label("Hoppers:"));
            t.add((WWidget)this.theme.label("" + this.chunk.hoppers));
        }
    }
}

